/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.4
* Description : 配置看门狗使能以及看门狗溢出时间和上电延时时间来控制系统何时溢出复位
*               现象：进入主程序后先是PB0进行翻转，一段时间后PB0停止翻转，改成PB1进行翻转
*               若不完成清看门狗，时间溢出复位后主程序会重头开始执行
*               若配置为禁止看门狗溢出复位，则超时也不会发生复位
***********************************************************************************************/

#include "AD18F08.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  禁止LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_ON          :  看门狗使能位
* _TWDT_100         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_ON_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_ON_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );
//---------配置字 WDTE 可选--------------
//_WDTE_ON_3L          使能看门狗复位
//_WDTE_OFF_3L         禁止看门狗复位
//------------------------
//通过配置TWDT可以配置WDT溢出时间
//配置方式(未使用分频)：   _TWDT_000_3L 128ms   _TWDT_001_3L 256ms   _TWDT_010_3L 384ms   _TWDT_011_3L 640ms
//                        _TWDT_100_3L 1.152s  _TWDT_101_3L 2.176s  _TWDT_110_3L 4.224s  _TWDT_111_3L 8.32s
//---------配置字 PSUT 可选--------------
//  _PSUT_8_3L         上电延时  18.55ms
//  _PSUT_4_3L         上电延时  288.55ms
//  _PSUT_2_3L         上电延时  864.55ms
//  _PSUT_1_3L         上电延时  1.05ms
//------------------------
//注：若配置字中使能了WDT则上电延时时间不可大于WDT时间，否则无法进入主函数。如选择延时为864.55ms时，WDT溢出时间只可选择1.152s及以上。

void main(void)
{
    unsigned char i;

	TRISB = 0xFC;             //设置PB0和PB1为输出
    PREDIV2 = 0;
	PREDIV1 = 0;
	PREDIV0 = 1;
	CLRWDT();           	//分频配置完后需要清狗(或者配置字关闭看门狗,WDTEN = 1就无需清狗)
	//WDTEN = 1;            //WDTEN=1或配置字中WDTE选择_WDTE_ON_3L 都可使能WDT
    //PREDIV[2:0]=0;WDT 1分频
    //PREDIV[2:0]=1;WDT 2分频
	//PREDIV[2:0]=2;WDT 3分频
	//PREDIV[2:0]=3;//WDT 4分频
	//PREDIV[2:0]=4;WDT 5分频
	//PREDIV[2:0]=5;WDT 6分频
	//PREDIV[2:0]=6;WDT 7分频
	//PREDIV[2:0]=7;WDT 8分频
   for(i = 0;i<100;i++)
    {
      PB0 = ~PB0;             //PB0翻转数次
    }

	while(1)
	{
		PB0 = 0;
	    PB1 = ~PB1;             //PB1翻转数次

	    //  CLRWDT();           //清狗

	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

